model:setName( "CrossBalance" )
model:caption( "Cross Balance" )

model:addSource("inputImage")

f1 = model:addFilter( "FilmTypes" )
f2 = model:addFilter( "LevelsAndCurvesFilter" )

-- Daylight to Tungsten 01
curveCrossBalance_Lum_0 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.1375"/>
	<key name="intNodeY0" value="0.10625"/>
	<key name="intNodeX1" value="0.81875"/>
	<key name="intNodeY1" value="0.86250"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_0 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.5"/>
	<key name="intNodeY0" value="0.56875"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_0 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.43125"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_0 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.50625"/>
	<key name="intNodeY0" value="0.33750"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- Daylight to Tungsten 02
curveCrossBalance_Lum_1 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.1625"/>
	<key name="intNodeY0" value="0.10625"/>
	<key name="intNodeX1" value="0.775"/>
	<key name="intNodeY1" value="0.84375"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_1 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.61250"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_1 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.38750"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_1 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.26875"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- Daylight to Tungsten 03
curveCrossBalance_Lum_2 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.20625"/>
	<key name="intNodeY0" value="0.175"/>
	<key name="intNodeX1" value="0.8375"/>
	<key name="intNodeY1" value="0.8875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_2 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.34375"/>
	<key name="intNodeX1" value="0.4875"/>
	<key name="intNodeY1" value="0.6875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_2 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.3"/>
	<key name="intNodeY0" value="0.15625"/>
	<key name="intNodeX1" value="0.5"/>
	<key name="intNodeY1" value="0.34375"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_2 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.1875"/>
	<key name="intNodeX1" value="0.79375"/>
	<key name="intNodeY1" value="0.49375"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- Tungsten to Daylight 01
curveCrossBalance_Lum_3 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.20625"/>
	<key name="intNodeY0" value="0.15625"/>
	<key name="intNodeX1" value="0.8375"/>
	<key name="intNodeY1" value="0.9"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_3 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.50625"/>
	<key name="intNodeY0" value="0.4625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_3 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.5"/>
	<key name="intNodeY0" value="0.55"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_3 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.59375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
			  
-- Tungsten to Daylight 02
curveCrossBalance_Lum_4 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.20625"/>
	<key name="intNodeY0" value="0.15625"/>
	<key name="intNodeX1" value="0.8375"/>
	<key name="intNodeY1" value="0.9"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_4 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.51875"/>
	<key name="intNodeY0" value="0.38125"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_4 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.5"/>
	<key name="intNodeY0" value="0.58750"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_4 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.33125"/>
	<key name="intNodeX1" value="0.49375"/>
	<key name="intNodeY1" value="0.725"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
		
-- Tungsten to Daylight 03
curveCrossBalance_Lum_5 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.2125"/>
	<key name="intNodeY0" value="0.2125"/>
	<key name="intNodeX1" value="0.8125"/>
	<key name="intNodeY1" value="0.81875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Red_5 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.53125"/>
	<key name="intNodeY0" value="0.275"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Green_5 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.325"/>
	<key name="intNodeX1" value="0.5125"/>
	<key name="intNodeY1" value="0.725"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossBalance_Blue_5 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.15"/>
	<key name="intNodeY0" value="0.32"/>
	<key name="intNodeX1" value="0.5"/>
	<key name="intNodeY1" value="0.7625"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]


-- Function for SelectValue combo box
function selectValue(v)
  filter1 = model:getFilter(f1)
  lac = model:getFilter(f2)
	
  -- Daylight to Tungsten 01
  if( v==0 ) then  
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_0 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_0 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_0 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_0 )	
	
  -- Daylight to Tungsten 02
  elseif( v==1) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_1 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_1 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_1 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_1 )	
	
  -- Daylight to Tungsten 03
  elseif( v==2) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.05 )
    filter1:setFloatParameter( "saturationyellow", -0.05 )
    filter1:setFloatParameter( "saturationgreen", -0.05 )
    filter1:setFloatParameter( "saturationcyan", -0.05 )
    filter1:setFloatParameter( "saturationblue", -0.05 )
    filter1:setFloatParameter( "saturationmagenta", -0.05 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_2 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_2 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_2 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_2 )	

  -- Tungsten to Daylight 01	
  elseif( v==3) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_3 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_3 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_3 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_3 )	

  -- Tungsten to Daylight 02
  elseif( v==4) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.03 )
    filter1:setFloatParameter( "saturationyellow", -0.03 )
    filter1:setFloatParameter( "saturationgreen", -0.03 )
    filter1:setFloatParameter( "saturationcyan", -0.03 )
    filter1:setFloatParameter( "saturationblue", -0.03 )
    filter1:setFloatParameter( "saturationmagenta", -0.03 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )  

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_4 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_4 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_4 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_4 )	

  -- Tungsten to Daylight 03
  elseif( v==5) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.06 )
    filter1:setFloatParameter( "saturationyellow", -0.06 )
    filter1:setFloatParameter( "saturationgreen", -0.08 )
    filter1:setFloatParameter( "saturationcyan", -0.10 )
    filter1:setFloatParameter( "saturationblue", -0.08 )
    filter1:setFloatParameter( "saturationmagenta", -0.06 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )  

	lac:setLacData( "lacdataRGB", curveCrossBalance_Lum_5 )
	lac:setLacData( "lacdataR", curveCrossBalance_Red_5 )
	lac:setLacData( "lacdataG", curveCrossBalance_Green_5 )
	lac:setLacData( "lacdataB", curveCrossBalance_Blue_5 )	
	
  end
end

model:addCombobox( "SelectValue", "selectValue", "", "Daylight To Tungsten (1);Daylight To Tungsten (2);Daylight To Tungsten (3);Tungsten To Daylight (1);Tungsten To Daylight (2);Tungsten To Daylight (3)" )
model:setIntParameter( "SelectValue" , 4)

function cbStrength(v)
  lac = model:getFilter(f2)
  lac:setFloatParameter( "strength", v*100 )
end
model:addFloatSlider( "CrossBalanceStrength", 0.7,0,1, "cbStrength", "Strength", "")


-- sets default parameter
selectValue(4)